<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 3.7.0 Beta 5 - Licence Number DGT-SERIAL
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2008 Jelsoft Enterprises Ltd. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

/**
* Fetches information about the selected message with permission checks
*
* @param	integer	The post we want info about
* @param	mixed		Should a permission check be performed as well
*
* @return	array	Array of information about the message or prints an error if it doesn't exist / permission problems
*/
function verify_groupmessage($gmid, $alert = true, $perm_check = true)
{
	global $vbulletin, $vbphrase;

	$messageinfo = fetch_groupmessageinfo($gmid);
	if (!$messageinfo)
	{
		if ($alert)
		{
			standard_error(fetch_error('invalidid', $vbphrase['social_group'], $vbulletin->options['contactuslink']));
		}
		else
		{
			return 0;
		}
	}

	if ($perm_check)
	{
		if ($messageinfo['state'] == 'deleted' AND !can_moderate())
		{
			standard_error(fetch_error('invalidid', $vbphrase['message'], $vbulletin->options['contactuslink']));
		}
		else if ($messageinfo['state'] == 'moderation' AND !can_moderate(0, 'canmoderategroupmessages') AND $messageinfo['postuserid'] != $vbulletin->userinfo['userid'])
		{
			standard_error(fetch_error('invalidid', $vbphrase['message'], $vbulletin->options['contactuslink']));
		}
// 	Need coventry support first
//		else if (in_coventry($userinfo['userid']) AND !can_moderate())
//		{
//			standard_error(fetch_error('invalidid', $vbphrase['gmessage'], $vbulletin->options['contactuslink']));
//		}
	}

	return $messageinfo;
}

/**
* Fetches information about the selected user message entry
*
* @param	integer	gmid of requested
*
* @return	array|false	Array of information about the user message or false if it doesn't exist
*/
function fetch_groupmessageinfo($gmid)
{
	global $vbulletin;
	static $groupmessagecache;

	$gmid = intval($gmid);
	if (!isset($groupmessagecache["$gmid"]))
	{
		$groupmessagecache["$gmid"] = $vbulletin->db->query_first("
			SELECT *
			FROM " . TABLE_PREFIX . "groupmessage AS groupmessage
			WHERE groupmessage.gmid = $gmid
		");
	}

	if (!$groupmessagecache["$gmid"])
	{
		return false;
	}
	else
	{
		return $groupmessagecache["$gmid"];
	}
}

/**
* Parse message content for preview
*
* @param	array		Message and disablesmilies options
*
* @return	string	Eval'd html for display as the preview message
*/
function process_group_message_preview($message)
{
	global $vbulletin, $vbphrase, $stylevar, $show;

	require_once(DIR . '/includes/class_bbcode.php');
	$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());
	$bbcode_parser->set_parse_userinfo($vbulletin->userinfo, $vbulletin->userinfo['permissions']);

	$previewhtml = '';
	if ($previewmessage = $bbcode_parser->parse($message['message'], 'visitormessage', $message['disablesmilies'] ? 0 : 1))
	{
		eval('$previewhtml = "' . fetch_template('visitormessage_preview'). '";');
	}

	return $previewhtml;
}

function fetch_socialgroupinfo($groupid)
{
	global $vbulletin;

	return prepare_socialgroup($vbulletin->db->query_first("
		SELECT socialgroup.*,
			user.username AS creatorusername
			" . ($vbulletin->userinfo['userid'] ? ', socialgroupmember.type AS membertype': '') . "
		FROM " . TABLE_PREFIX . "socialgroup AS socialgroup
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (socialgroup.creatoruserid = user.userid)
		" . ($vbulletin->userinfo['userid'] ?
			"LEFT JOIN " . TABLE_PREFIX . "socialgroupmember AS socialgroupmember ON
				(socialgroupmember.userid = " . $vbulletin->userinfo['userid'] . " AND socialgroupmember.groupid = socialgroup.groupid)" :
			'') . "
		WHERE socialgroup.groupid = " . intval($groupid) . "
	"));
}

function prepare_socialgroup($group)
{
	global $vbulletin;

	if (!is_array($group))
	{
		return array();
	}

	$group['joindate'] = ($group['joindate'] ? vbdate($vbulletin->options['dateformat'], $group['joindate'], true) : '');
	$group['createdate'] = ($group['createdate'] ? vbdate($vbulletin->options['dateformat'], $group['createdate'], true) : '');

	$group['members'] = vb_number_format($group['members']);
	$group['picturecount'] = vb_number_format($group['picturecount']);
	$group['moderatedmembers'] = vb_number_format($group['moderatedmembers']);

	$group['rawname'] = $group['name'];
	$group['rawdescription'] = $group['description'];

	$group['name'] = fetch_word_wrapped_string(fetch_censored_text($group['name']));
 	$group['shortdescription'] = fetch_word_wrapped_string(fetch_censored_text(fetch_trimmed_title($group['description'], 200)));
	$group['description'] = nl2br(fetch_word_wrapped_string(fetch_censored_text($group['description'])));

	$group['lastpostdate'] = vbdate($vbulletin->options['dateformat'], $group['lastpost'], true);
	$group['lastposttime'] = vbdate($vbulletin->options['timeformat'], $group['lastpost']);

	$group['is_owner'] = ($group['creatoruserid'] == $vbulletin->userinfo['userid']);

	($hook = vBulletinHook::fetch_hook('group_prepareinfo')) ? eval($hook) : false;

	return $group;
}

function fetch_socialgroup_picture($pictureid, $groupid)
{
	global $vbulletin;

	$picture = $vbulletin->db->query_first("
		SELECT picture.pictureid, picture.userid, picture.caption, picture.extension, picture.filesize,
			picture.width, picture.height, picture.reportthreadid,
			picture.idhash, picture.thumbnail_filesize,
			socialgrouppicture.dateline, socialgrouppicture.groupid, user.username
		FROM " . TABLE_PREFIX . "socialgrouppicture AS socialgrouppicture
		INNER JOIN " . TABLE_PREFIX . "picture AS picture ON (picture.pictureid = socialgrouppicture.pictureid)
		INNER JOIN " . TABLE_PREFIX . "socialgroupmember AS socialgroupmember ON
			(socialgroupmember.userid = picture.userid AND socialgroupmember.groupid = $groupid AND socialgroupmember.type = 'member')
		INNER JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = picture.userid)
		WHERE socialgrouppicture.groupid = $groupid
			AND socialgrouppicture.pictureid = $pictureid
	");

	($hook = vBulletinHook::fetch_hook('group_fetch_pictureinfo')) ? eval($hook) : false;

	return $picture;
}

function build_group_counters($groupid)
{
	global $vbulletin;

	if (!($groupid = intval($groupid)))
	{
		return;
	}

	$messages = $vbulletin->db->query_first("
		SELECT
			SUM(IF(state = 'visible', 1, 0)) AS visible,
			SUM(IF(state = 'deleted', 1, 0)) AS deleted,
			SUM(IF(state = 'moderation', 1, 0)) AS moderation
		FROM " . TABLE_PREFIX . "groupmessage
		WHERE groupid = $groupid
	");

	$lastpost = $vbulletin->db->query_first("
		SELECT user.username, postuserid, dateline, gmid
		FROM " . TABLE_PREFIX . "groupmessage AS gm
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = gm.postuserid)
		WHERE groupid = $groupid AND state = 'visible'
		LIMIT 1
	");

	$groupinfo = array('groupid' => $groupid);
	$dataman =& datamanager_init('SocialGroup', $vbulletin, ERRTYPE_SILENT);
	$dataman->set_existing($groupinfo);

	$dataman->set('lastpost', $lastpost['dateline']);
	$dataman->set('lastposter', $lastpost['username']);
	$dataman->set('lastposterid', $lastpost['postuserid']);
	$dataman->set('lastgmid', $lastpost['gmid']);
	$dataman->set('visible', $messages['visible']);
	$dataman->set('deleted', $messages['deleted']);
	$dataman->set('moderation', $messages['moderation']);

	($hook = vBulletinHook::fetch_hook('group_build_counters')) ? eval($hook) : false;

	$dataman->save();
}

function can_join_group(&$group)
{
	global $vbulletin;
	return (
		$vbulletin->options['socnet'] & $vbulletin->bf_misc_socnet['enable_groups']
		AND $vbulletin->userinfo['userid']
		AND $vbulletin->userinfo['permissions']['socialgrouppermissions'] & $vbulletin->bf_ugp_socialgrouppermissions['canjoingroups']
		AND
		(
			$group['membertype'] == 'invited'
			OR
			(
				$group['type'] != 'inviteonly'
				AND empty($group['membertype'])
			)
		)

	);
}

function can_leave_group(&$group)
{
	global $vbulletin;


	return (
		$vbulletin->options['socnet'] & $vbulletin->bf_misc_socnet['enable_groups']
		AND $vbulletin->userinfo['userid']
		AND !empty($group['membertype'])
		AND !$group['is_owner']
	);
}

function can_edit_group(&$group)
{
	global $vbulletin;

	return (
		$vbulletin->options['socnet'] & $vbulletin->bf_misc_socnet['enable_groups']
		AND $vbulletin->userinfo['userid']
		AND
		(
			(
				$group['is_owner']
				AND
				(
					$vbulletin->userinfo['permissions']['socialgrouppermissions'] & $vbulletin->bf_ugp_socialgrouppermissions['caneditowngroups']
					OR $group['members'] == 1
				)
			)
			OR can_moderate(0, 'caneditsocialgroups')
		)
	);
}

function can_delete_group(&$group)
{
	global $vbulletin;

	return (
		$vbulletin->options['socnet'] & $vbulletin->bf_misc_socnet['enable_groups']
		AND $vbulletin->userinfo['userid']
		AND
		(
			(
				$group['is_owner']
				AND
				(
					$vbulletin->userinfo['permissions']['socialgrouppermissions'] & $vbulletin->bf_ugp_socialgrouppermissions['candeleteowngroups']
					OR $group['members'] == 1
				)
			)
			OR can_moderate(0, 'candeletesocialgroups')
		)
	);
}

function can_manage_group(&$group)
{
	global $vbulletin;

	return (
		$vbulletin->options['socnet'] & $vbulletin->bf_misc_socnet['enable_groups']
		AND $vbulletin->userinfo['userid']
		AND
		(
			$group['is_owner']
			OR can_moderate(0, 'candeletesocialgroups')
		)
	);
}


/*======================================================================*\
|| ####################################################################
|| # Downloaded: DGT-DATE
|| # CVS: $RCSfile$ - $Revision: 25686 $
|| ####################################################################
\*======================================================================*/
?>